// JavaScript Document
//HTML5 Ad Template JS from DoubleClick by Google

var collapsedPanel;
var expandedPanel;
var expandBtn;
var exitBtn;
var closeBtn;
var poster;
var vplayer;
var bigPlay;
var isplaying;

// =============================================================================================
dcrmInit = function(){
	collapsedPanel = document.getElementById('collapsed');
	expandedPanel = document.getElementById('expanded');
	expandBtn = document.getElementById('i_background_mc');
	exitBtn = document.getElementById('left_mc');
	closeBtn = document.getElementById('close_mc');
    poster = document.getElementById('poster_mc');
	
	
	vplayer = document.getElementById('vplayer');

	isplaying = false;
	addListeners();
	
}
addListeners = function (){
	collapsedPanel.addEventListener('click', onExpandHandler, false);
	exitBtn.addEventListener('click', onExitHandler, false);
	closeBtn.addEventListener('click', onCloseHandler, false);
	
	document.getElementById('videoContent').addEventListener('click', playPause);
	vplayer.addEventListener('ended', posterToggle, false);

	// Video Reporting Identifier
	Enabler.loadModule(studio.module.ModuleId.VIDEO, function() {
   		studio.video.Reporter.attach('video_1', vplayer);
	});
  	Enabler.addEventListener(studio.events.StudioEvent.EXPAND_START,
    function() {
		console.log("Controls = true")
		vplayer.controls = true;
		poster.style.display = "none";
    	vplayer.play();
        
        vplayer.style.display = "block";
		isplaying = true;
		
    	Enabler.startTimer('expanded_panel');
		collapsedPanel.style.display = "none";
		expandedPanel.style.display = "block";

		Enabler.finishExpand();
	});

  	// Collapse Event Listeners
  	Enabler.addEventListener(studio.events.StudioEvent.COLLAPSE_START,
    function() {
		Enabler.stopTimer('expanded_panel');
   		Enabler.finishCollapse();
		});

  	Enabler.addEventListener(studio.events.StudioEvent.COLLAPSE_FINISH,
    function() {
		vplayer.pause();
		vplayer.currentTime = 0;

		expandedPanel.style.display = "none";
		collapsedPanel.style.display = "block";
		isplaying = false;

	});
}


// =======================================Video Content=======================================
function posterToggle(){
    document.getElementById("poster_mc").style.display = "block";
    vplayer.style.display = "none";
    document.getElementById("poster_mc").addEventListener("click", videoPlay, false);
}

function videoPlay(){
    document.getElementById("poster_mc").style.display = "none";
    vplayer.style.display = "block";
    vplayer.play();
    vplayer.muted = false;
    addListeners();
}
//
//function posterToggle(){
//    if(document.getElementById("vplayer").currentTime == 0){
//        document.getElementById("poster_mc").style.display = "block";
//        document.getElementById("vplayer").style.display = "none";
//    }
//}

onVideoComplete = function(){
	vplayer.currentTime = 0;
	vplayer.pause();
	isplaying = false;
}
clickToPlay = function(){
	vplayer.play();
	vplayer.muted = false;
	isplaying = true;
}
on_Mute = function(){
	vplayer.muted = false;
}
on_Unmute = function(){
	vplayer.muted = true;	
}
on_Stop = function(){
	vplayer.pause();
	vplayer.currentTime = 0;
	isplaying = false;
}
onExpandHandler = function(e){
    vplayer.muted = false;
	Enabler.requestExpand();
}
onExitHandler = function(e){
	onCloseHandler();
	Enabler.exit("cta_clicked");
	vplayer.pause();
}
onCloseHandler = function(e){
	Enabler.counter('Manual_Close');
	Enabler.reportManualClose();
	closeAd();
}
closeAd = function(){
	Enabler.requestCollapse();
}
playPause = function(evt){
	if(!(navigator.userAgent.toLowerCase().indexOf('firefox') > -1)){
		if(!isplaying){
			vplayer.play();
			isplaying = true;
		}else{
			vplayer.pause();
			isplaying = false;
		}
	}
}
window.onload = function() {
  /* Initialize Enabler */
  if (Enabler.isInitialized()) {
    dcrmInit();
  } else {
    Enabler.addEventListener(studio.events.StudioEvent.INIT, dcrmInit);
  }
}
  